"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UI_PRIVATE_TENANT_NAME = exports.UI_GLOBAL_TENANT_NAME = exports.PRIVATE_TENANT_NAME = exports.MISSING_TENANT_PARAMETER_VALUE = exports.GLOBAL_TENANT_NAME = void 0;
exports.tenantNameToUiTenantName = tenantNameToUiTenantName;
exports.uiTenantNameToTenantName = uiTenantNameToTenantName;
/*
 *    Copyright 2021 floragunn GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

const UI_GLOBAL_TENANT_NAME = exports.UI_GLOBAL_TENANT_NAME = 'Global';
const UI_PRIVATE_TENANT_NAME = exports.UI_PRIVATE_TENANT_NAME = 'Private';
/**
 * The internal name for the global tenant, as used in the sgtenant header
 * @type {string}
 */
const GLOBAL_TENANT_NAME = exports.GLOBAL_TENANT_NAME = 'SGS_GLOBAL_TENANT';
// @todo Maybe I can remove this again?
//export const GLOBAL_TENANT_NAME_WITH_LABEL = 'SGS_GLOBAL_TENANT';
const PRIVATE_TENANT_NAME = exports.PRIVATE_TENANT_NAME = '__user__';
const MISSING_TENANT_PARAMETER_VALUE = exports.MISSING_TENANT_PARAMETER_VALUE = 'missingTenant';
function tenantNameToUiTenantName(name) {
  if (!name) return UI_GLOBAL_TENANT_NAME;
  const map = new Map([[GLOBAL_TENANT_NAME, UI_GLOBAL_TENANT_NAME], [PRIVATE_TENANT_NAME, UI_PRIVATE_TENANT_NAME]]);
  return map.get(name) || name;
}
function uiTenantNameToTenantName(name) {
  const map = new Map([[UI_GLOBAL_TENANT_NAME, GLOBAL_TENANT_NAME], [UI_PRIVATE_TENANT_NAME, PRIVATE_TENANT_NAME]]);
  const tenantName = map.get(name);
  return tenantName === GLOBAL_TENANT_NAME ? tenantName : tenantName || name;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJVSV9HTE9CQUxfVEVOQU5UX05BTUUiLCJleHBvcnRzIiwiVUlfUFJJVkFURV9URU5BTlRfTkFNRSIsIkdMT0JBTF9URU5BTlRfTkFNRSIsIlBSSVZBVEVfVEVOQU5UX05BTUUiLCJNSVNTSU5HX1RFTkFOVF9QQVJBTUVURVJfVkFMVUUiLCJ0ZW5hbnROYW1lVG9VaVRlbmFudE5hbWUiLCJuYW1lIiwibWFwIiwiTWFwIiwiZ2V0IiwidWlUZW5hbnROYW1lVG9UZW5hbnROYW1lIiwidGVuYW50TmFtZSJdLCJzb3VyY2VzIjpbIm11bHRpdGVuYW5jeS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogICAgQ29weXJpZ2h0IDIwMjEgZmxvcmFndW5uIEdtYkhcbiAqXG4gKiBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpO1xuICogeW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZSB3aXRoIHRoZSBMaWNlbnNlLlxuICogWW91IG1heSBvYnRhaW4gYSBjb3B5IG9mIHRoZSBMaWNlbnNlIGF0XG4gKlxuICogaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogVW5sZXNzIHJlcXVpcmVkIGJ5IGFwcGxpY2FibGUgbGF3IG9yIGFncmVlZCB0byBpbiB3cml0aW5nLCBzb2Z0d2FyZVxuICogZGlzdHJpYnV0ZWQgdW5kZXIgdGhlIExpY2Vuc2UgaXMgZGlzdHJpYnV0ZWQgb24gYW4gXCJBUyBJU1wiIEJBU0lTLFxuICogV0lUSE9VVCBXQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGVpdGhlciBleHByZXNzIG9yIGltcGxpZWQuXG4gKiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnMgYW5kXG4gKiBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG5leHBvcnQgY29uc3QgVUlfR0xPQkFMX1RFTkFOVF9OQU1FID0gJ0dsb2JhbCc7XG5leHBvcnQgY29uc3QgVUlfUFJJVkFURV9URU5BTlRfTkFNRSA9ICdQcml2YXRlJztcbi8qKlxuICogVGhlIGludGVybmFsIG5hbWUgZm9yIHRoZSBnbG9iYWwgdGVuYW50LCBhcyB1c2VkIGluIHRoZSBzZ3RlbmFudCBoZWFkZXJcbiAqIEB0eXBlIHtzdHJpbmd9XG4gKi9cbmV4cG9ydCBjb25zdCBHTE9CQUxfVEVOQU5UX05BTUUgPSAnU0dTX0dMT0JBTF9URU5BTlQnO1xuLy8gQHRvZG8gTWF5YmUgSSBjYW4gcmVtb3ZlIHRoaXMgYWdhaW4/XG4vL2V4cG9ydCBjb25zdCBHTE9CQUxfVEVOQU5UX05BTUVfV0lUSF9MQUJFTCA9ICdTR1NfR0xPQkFMX1RFTkFOVCc7XG5leHBvcnQgY29uc3QgUFJJVkFURV9URU5BTlRfTkFNRSA9ICdfX3VzZXJfXyc7XG5cbmV4cG9ydCBjb25zdCBNSVNTSU5HX1RFTkFOVF9QQVJBTUVURVJfVkFMVUUgPSAnbWlzc2luZ1RlbmFudCc7XG5cbmV4cG9ydCBmdW5jdGlvbiB0ZW5hbnROYW1lVG9VaVRlbmFudE5hbWUobmFtZSkge1xuICBpZiAoIW5hbWUpIHJldHVybiBVSV9HTE9CQUxfVEVOQU5UX05BTUU7XG5cbiAgY29uc3QgbWFwID0gbmV3IE1hcChbXG4gICAgW0dMT0JBTF9URU5BTlRfTkFNRSwgVUlfR0xPQkFMX1RFTkFOVF9OQU1FXSxcbiAgICBbUFJJVkFURV9URU5BTlRfTkFNRSwgVUlfUFJJVkFURV9URU5BTlRfTkFNRV0sXG4gIF0pO1xuXG4gIHJldHVybiBtYXAuZ2V0KG5hbWUpIHx8IG5hbWU7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiB1aVRlbmFudE5hbWVUb1RlbmFudE5hbWUobmFtZSkge1xuICBjb25zdCBtYXAgPSBuZXcgTWFwKFtcbiAgICBbVUlfR0xPQkFMX1RFTkFOVF9OQU1FLCBHTE9CQUxfVEVOQU5UX05BTUVdLFxuICAgIFtVSV9QUklWQVRFX1RFTkFOVF9OQU1FLCBQUklWQVRFX1RFTkFOVF9OQU1FXSxcbiAgXSk7XG5cbiAgY29uc3QgdGVuYW50TmFtZSA9IG1hcC5nZXQobmFtZSk7XG4gIHJldHVybiB0ZW5hbnROYW1lID09PSBHTE9CQUxfVEVOQU5UX05BTUUgPyB0ZW5hbnROYW1lIDogdGVuYW50TmFtZSB8fCBuYW1lO1xufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFTyxNQUFNQSxxQkFBcUIsR0FBQUMsT0FBQSxDQUFBRCxxQkFBQSxHQUFHLFFBQVE7QUFDdEMsTUFBTUUsc0JBQXNCLEdBQUFELE9BQUEsQ0FBQUMsc0JBQUEsR0FBRyxTQUFTO0FBQy9DO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTUMsa0JBQWtCLEdBQUFGLE9BQUEsQ0FBQUUsa0JBQUEsR0FBRyxtQkFBbUI7QUFDckQ7QUFDQTtBQUNPLE1BQU1DLG1CQUFtQixHQUFBSCxPQUFBLENBQUFHLG1CQUFBLEdBQUcsVUFBVTtBQUV0QyxNQUFNQyw4QkFBOEIsR0FBQUosT0FBQSxDQUFBSSw4QkFBQSxHQUFHLGVBQWU7QUFFdEQsU0FBU0Msd0JBQXdCQSxDQUFDQyxJQUFJLEVBQUU7RUFDN0MsSUFBSSxDQUFDQSxJQUFJLEVBQUUsT0FBT1AscUJBQXFCO0VBRXZDLE1BQU1RLEdBQUcsR0FBRyxJQUFJQyxHQUFHLENBQUMsQ0FDbEIsQ0FBQ04sa0JBQWtCLEVBQUVILHFCQUFxQixDQUFDLEVBQzNDLENBQUNJLG1CQUFtQixFQUFFRixzQkFBc0IsQ0FBQyxDQUM5QyxDQUFDO0VBRUYsT0FBT00sR0FBRyxDQUFDRSxHQUFHLENBQUNILElBQUksQ0FBQyxJQUFJQSxJQUFJO0FBQzlCO0FBRU8sU0FBU0ksd0JBQXdCQSxDQUFDSixJQUFJLEVBQUU7RUFDN0MsTUFBTUMsR0FBRyxHQUFHLElBQUlDLEdBQUcsQ0FBQyxDQUNsQixDQUFDVCxxQkFBcUIsRUFBRUcsa0JBQWtCLENBQUMsRUFDM0MsQ0FBQ0Qsc0JBQXNCLEVBQUVFLG1CQUFtQixDQUFDLENBQzlDLENBQUM7RUFFRixNQUFNUSxVQUFVLEdBQUdKLEdBQUcsQ0FBQ0UsR0FBRyxDQUFDSCxJQUFJLENBQUM7RUFDaEMsT0FBT0ssVUFBVSxLQUFLVCxrQkFBa0IsR0FBR1MsVUFBVSxHQUFHQSxVQUFVLElBQUlMLElBQUk7QUFDNUUifQ==